class GlobalStats extends Mutator;

var string	URL, Path;			/* Default URL="http://www.globalstats.unrealtournament.info",Path"/Serverlink/link.php" */
var GlobalStatsWEBLink WL;

//Define the struct of Data that collects player info:
struct Data
{
var string	zzName;				//holds the players name

};

//Define the struct of Beacon that collects server info:
struct Beacon
{
var string	zzServerName;			//holds the servers name
var string	zzIP;					//holds the IP and port info, syntax 123.123.123.123:7777
var string	zzAdmin;				//holds the name of the administrator
var string	zzAdminEmail;			//holds the contact email of the admin
var string	zzMapName;				//holds the mapname, syntax Prefix-MapName
};

var Data info[128];
var Beacon serverinfo;
var GameReplicationInfo GRI;
var bool bServerInfoSet;

function GetServerInfo()
{
local string LocalURL;
local int length;

	serverinfo.zzServerName = GRI.ServerName;
	if ( GRI.AdminName != "" )
		serverinfo.zzAdmin = GRI.AdminName;
	else
		serverinfo.zzAdmin = "N/A";
	if ( GRI.AdminEmail != "" )
		serverinfo.zzAdminEmail = GRI.AdminEmail;
	else
		serverinfo.zzAdminEmail = "N/A";
	serverinfo.zzIP = Level.Game.GetNetworkNumber()$":"$Level.Game.GetServerPort();
	
	LocalURL = Level.GetLocalURL();
	LocalURL = Left(LocalURL, InStr(LocalURL, ".unr"));
	LocalURL = Mid(LocalURL, InStr(LocalURL, "/"));
	length = len(LocalURL);
	LocalURL = Right(LocalURL, length - 1);
	serverinfo.zzMapName = LocalURL;
	
	log ("Global Statistics: ServerName:"$serverinfo.zzServerName);
	log ("Global Statistics: ServerIP:"$serverinfo.zzIP);
	log ("Global Statistics: AdminName:"$serverinfo.zzAdmin);
	log ("Global Statistics: AdminEmail:"$serverinfo.zzAdminEmail);
	log ("Global Statistics: MapName:"$serverinfo.zzMapName);
	
	if ( WL != none )
		{
		WL.SendServerBeacon(serverinfo.zzServerName$","$serverinfo.zzIP$","$serverinfo.zzAdmin$","$serverinfo.zzAdminEmail$","$serverinfo.zzMapName);
		}
	else
		log("Global Statistics: ERROR! Failed to find link actor.");
}

function ModifyPlayer(Pawn Other)
{
	if ( Other.IsA('PlayerPawn') && !bServerInfoSet )
		{
		GRI = PlayerPawn(Other).GameReplicationInfo;
		GetServerInfo();
		bServerInfoSet = True;
		}
	
	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}

function PostBeginPlay()
{
local GlobalStatsWEBLink A;

	SetTimer(10.0,True);	
	log("Global statistics: Booting up.");
	
	WL = Spawn(class'GlobalStatsWEBLink');;
		
	if ( WL != none )
		{
		log("Global statistics: Link established.");
		WL.URL = URL;
		WL.Path = Path;
		}
	else
		{
		log("Global statistics: ERROR! Link actor missing.");
		}
}

function Timer()
{
SetTimer(1.0,True);
}

defaultproperties:
{
bHidden=True
}